%
% Generate Figure 10.11 in the book:
%
% J. M. Mendel and Dongrui Wu, Perceptual Computing: Aiding People in
% Making Subjective Judgments, Wiley-IEEE Press, 2010.
%
% Dongrui WU (dongruiw@usc.edu), 4/19/2009
%

clc
close all
clear all
warning off all

%% Reviewer1's selection
% Style varies from Poor to Excellent
X12=[1 1 5 1;
    2 1 5 1;
    3 1 5 1;
    4 1 5 1;
    5 1 5 1];

% Style and clarity have larger weights
W2=[2 1 2 1];

%% Five MFs used by each measure
Vocabulary =[0   0    1.5  3.5  0   0    0.5  2.5 1;
    0.5 2.5  3.5  5.5  1.5 3    3    4.5 0.75;
    2.5 4.5  5.5  7.5  3.5 5    5    6.5 0.75;
    4.5 6.5  7.5  9.5  5.5 7    7    8.5 0.75;
    6.5 8.5  10   10   7.5 9.5  10   10  1];

%% Weights corresponding to the measures
Weights2=[[2.5 4.5 5.5 7.5 3.5 5 5 6.5]-2.5 .75;
    [2.5 4.5 5.5 7.5 3.5 5 5 6.5]+2.5 .75];

%% %%%%%%%%%%%%%%%% LWA for Measure 2: Prentation %%%%%%%%%%%%%%%%%
numbers1='acegi';
numbers2='bdfhj';
for k=1:5
    Xs=Vocabulary(X12(k,:),:);
    Ws=Weights2(W2,:);
    Y2 = LWA(Xs,Ws);

    figure
    set(gcf,'DefaulttextFontName','times new roman');
    set(gcf,'DefaultaxesFontName','times new roman');
    set(gcf,'DefaulttextFontAngle','italic');
    set(gcf,'DefaulttextFontSize',8);
    set(gcf,'DefaultaxesFontSize',8);
    set(gcf,'DefaultlineLineWidth',1.2);
    set(gcf,'DefaultaxesLineWidth',.35);
    subplot(5.5,2,1)
    for i=1:4
        fill([Vocabulary(X12(k,i),1:4) Vocabulary(X12(k,i),8:-1:5)],...
            [0 1 1 0 0 Vocabulary(X12(k,i),9) Vocabulary(X12(k,i),9) 0],[0.9 0.9 0.9]);
        hold on;
    end
    for i=1:4
        plot([Vocabulary(X12(k,i),1:4) Vocabulary(X12(k,i),8:-1:5)],...
            [0 1 1 0 0 Vocabulary(X12(k,i),9) Vocabulary(X12(k,i),9) 0],'k-');
    end
    axis([0 11 0 1.3]);
    box off
    text(11.2,0.02,'x');
    text(0.15,1.25,'u');
    arrow([0,0],[11,0],0.06,pi/10,0.5,[0 0 0],'-');
    arrow([0,0.8],[0,1.3],0.06,pi/10,0.5,[0 0 0],'-');
    set(gca,'YTick',[0:0.25:1]);
    set(gca,'XTick',[0:1:10]);

    if k==2 | k==3 | k==4
        text('Interpreter','latex','String','$$\widetilde{X}_{S}$$','Position',[mean(Vocabulary(X12(k,1),2:3))-.3,1.18]);
        text('Interpreter','latex','String','$$\widetilde{X}_{Cl}$$','Position',[mean(Vocabulary(X12(k,3),2:3))-.3,1.18]);
        text('Interpreter','latex','String','$$\widetilde{X}_{O}=\widetilde{X}_{R}$$','Position',[mean(Vocabulary(X12(k,4),2:3))-.3,1.18]);
    elseif k==1
        text('Interpreter','latex','String','$$\widetilde{X}_{S}=\widetilde{X}_{O}=\widetilde{X}_{R}$$','Position',[mean(Vocabulary(X12(k,1),2:3))-.3,1.18]);
        text('Interpreter','latex','String','$$\widetilde{X}_{Cl}$$','Position',[mean(Vocabulary(X12(k,3),2:3))-.3,1.18]);
    elseif k==5
        text('Interpreter','latex','String','$$\widetilde{X}_{S}=\widetilde{X}_{Cl}$$','Position',[mean(Vocabulary(X12(k,1),2:3))-1.2,1.18]);
        text('Interpreter','latex','String','$$\widetilde{X}_{O}=\widetilde{X}_{R}$$','Position',[mean(Vocabulary(X12(k,4),2:3))-.3,1.18]);
    end
    saveas(gcf,['Fig10-11' numbers1(k) '.eps']);


    figure
    set(gcf,'DefaulttextFontName','times new roman');
    set(gcf,'DefaultaxesFontName','times new roman');
    set(gcf,'DefaulttextFontAngle','italic');
    set(gcf,'DefaulttextFontSize',8);
    set(gcf,'DefaultaxesFontSize',8);
    set(gcf,'DefaultlineLineWidth',1.2);
    set(gcf,'DefaultaxesLineWidth',.35);
    subplot(5.5,2,1)
    fill([Y2(1:4) Y2(8:-1:5)],[0 1 1 0 0 Y2([9 9]) 0],[0.9 0.9 0.9]);
    hold on;
    plot([Y2(1:4) Y2(8:-1:5)],[0 1 1 0 0 Y2([9 9]) 0],'k-');
    axis([0 11 0 1.3]);
    box off
    text(11.2,0.02,'y');
    text(0.15,1.25,'u');
    arrow([0,0],[11,0],0.06,pi/10,0.5,[0 0 0],'-');
    arrow([0,0.8],[0,1.3],0.06,pi/10,0.5,[0 0 0],'-');
    text('Interpreter','latex','String','$$\widetilde{Y}_{P}$$','Position',[mean(Y2(2:3))-0.3,1.18]);
    set(gca,'YTick',[0:0.25:1]);
    set(gca,'XTick',[0:1:10]);
    saveas(gcf,['Fig10-11' numbers2(k) '.eps']);
end

close all
